#!/bin/sh
# update by obi

#echo "[update.sh] $*"

startconfig=/mnt/config/start-config
if [ ! -e "$startconfig" ]; then startconfig="/etc/titan.restore/mnt/config/start-config"; fi

. $startconfig
cd /tmp
boxtype=`cat /etc/model`
buildgroup=`cat /etc/.buildgroup`
arch=`cat /etc/.arch`
event=`cat /mnt/config/titan.cfg | grep rcdev= | tr '/' '\n' | tail -n1`
swtype="titan"
board=`cat /etc/.board`
bootversion=`cat /etc/version`

echo "[update.sh] booted version $bootversion"

source=$1			# getfilelist|tmp|online
target=$2			# kernel|var|root|full|backup or label or device or empty
file=$3				# file to flash/update or empty
user=$4
pass=$5
imgtype=$6		# release|dev
url=$7
targetfull=$target

vfd=vfd

if [ "$source" = "getfilelist" ];then
	user=$2
	pass=$3
	imgtype=$4
	url=$5
fi
### got parameters for online ###
#url=`cat /var/etc/ipkg/official-feed.conf | cut -d '/' -f4 | head -n1`
#urldir=`cat /var/etc/ipkg/official-feed.conf | cut -d '/' -f5 | head -n1`
urldir="svn"

url="http://$user:$pass@$url"
folder="image"

if [ "$imgtype" == "dev" ]; then
	folder="image-beta"
fi

tversion=`cat /etc/version | tr '_' '\n' | tail -n1`

### get online filelist if source=getfilelist ###
if [ "$source" == "getfilelist" ]; then
	umount -fl /tmp/mnt > /dev/null 2>&1
	umount -fl /tmp/mnt > /dev/null 2>&1
	cd /tmp
	mkdir -p online
	rm -f online/*
	rm -f list."$boxtype"
	
	if [ -e /etc/.beta ] && [ "$imgtype" == "release" ]; then
		wget -T15 "$url/$urldir/$folder/list.auto.$boxtype" -O /tmp/list.$boxtype
	elif [ -e /etc/.beta ] || [ "$imgtype" == "dev" ]; then
		wget -T15 "$url/$urldir/$folder/list.$boxtype" -O /tmp/list.$boxtype
	else
# disable ab v1.78
#		wget -T15 "$url/$urldir/$folder/list.$boxtype.$tversion" -O /tmp/list.$boxtype
		wget -T15 "$url/$urldir/$folder/list.auto.$boxtype" -O /tmp/list.$boxtype
	fi
	sync
	if [ -e "/etc/.stable" ] && [ ! -e /etc/.beta ] && [ "$imgtype" == "release" ] && ([ "$boxtype" == "atemio6000" ] || [ "$boxtype" == "atemio6100" ] || [ "$boxtype" == "atemio6200" ]); then
		filelist=`cat /tmp/list."$boxtype" | grep "_stable"`
	elif [ ! -e /etc/.beta ] && [ "$imgtype" == "release" ] && ([ "$boxtype" == "atemio6000" ] || [ "$boxtype" == "atemio6100" ] || [ "$boxtype" == "atemio6200" ]); then
		filelist=`cat /tmp/list."$boxtype" | grep "_nightly"`
	else
		filelist=`cat /tmp/list."$boxtype"`
	fi

	imgversion=`cat /etc/version | cut -d "_" -f2 | sed 's/M//'`
	if [ -z "$imgversion" ]; then
		echo "[update.sh] imgversion not found, use 0"
		imgversion=0;
	elif [ -e /etc/.beta ]; then
		imgversion=0
	elif [ "$imgtype" == "dev" ]; then
		imgversion=0
	else
#		imgversion=`expr $imgversion - 1`
#		imgversion=$imgversion
		imgversion=0
	fi
	if [ -z "$imgversion" ]; then
		echo "[update.sh] imgversion not found, use 0"
		imgversion=0;
	fi

	if [ -z "$updatelist" ]; then updatelist=10; fi
	showfromversion=`expr $imgversion - $updatelist`

	error="1"
	uptodate="1"

	for line in $filelist; do
		error="0"
#		version=`echo "$line" | cut -d "_" -f2 | sed 's/M//'`

		if [ `echo "$line" | grep ^M | wc -l` -eq 1 ];then
			version=`echo "$line" | cut -d "_" -f1 | sed 's/M//'`
		else
			version=${line#*_}
			version=${version%%_*}
			version=${version/M/}
		fi
#		if [ $showfromversion -lt $version ]; then
		if [ $version -gt $imgversion ]; then
			echo "[update.sh] newerfile: $line"
			uptodate="0"
			> "/tmp/online/$line";
		fi
	done
	sync
	### don't change this echo message, is used in panel ###
	if [ "$error" == "1" ];then
		rm -f online/*
		rm -f list."$boxtype"
		echo "[update.sh] error"
	elif [ "$uptodate" == "1" ];then
		echo "[update.sh] uptodate"
	fi

	exit 0
fi

### check input ###
if [ -z "$source" ] || [ -z "$target" ] || [ -z "$file" ]; then
	usage="1"
fi
if [ "$source" != "online" ] && [ "$source" != "tmp" ]; then
	usage="1"
fi

### print usage ###
if [ "$usage" == "1" ]; then
#	echo "GetOnlineFilelist		:  update.sh  getfilelist"
#	echo "FlashOnlineUpdate		:  update.sh  online kernel|var|root|full filename"
#	echo "FlashTmpUpdate			:  update.sh  tmp kernel|var|root|full filename"
#	echo "UsbOnlineUpdate			:  update.sh  online label|dev filename"
#	echo "UsbTmpUpdate				:  update.sh  tmp label|dev filename"
 	exit 1
fi

### got update to ###
if [ "$target" == "kernel" ] || [ "$target" == "var" ] || [ "$target" == "root" ] || [ "$target" == "full" ] || [ "$target" == "fullbackup" ]; then
	update_to="flash"
	target=`echo "$target" | tr "a-z" "A-Z"`
else
	update_to="usb"
fi

### make filenames ###
tmp="/tmp"

### other update handling for some boxes if full image is to big for /tmp (flash) ###
#if [ "$target" == "FULL" ] && [ "$boxtype" == "xxxxx" ]; then target="KERNEL VAR ROOT"; fi


### other update handling for some boxes if full image is to big for /tmp (usb) ###
if [ "USBFULL" == `basename "$file" | cut -d "_" -f5` ]; then bigimage=1; fi

### flash is nand ###
#if [ "$boxtype" == "ufs912" ] || [ "$boxtype" == "atemio-nemesis" ] || [ "$boxtype" = "atemio5200" ] || [ "$boxtype" = "vusolo2" ] || [ $boxtype = "atemio6000" ] || [ $boxtype = "atemio6100" ] || [ $boxtype = "atemio6200" ]; then
	nandbox="0"
#fi

make_tmp()
{
	mkdir /tmp/mktmp
	mkdir /tmp/lib
	cp /bin/busybox.nosuid /tmp
	ln -s /tmp/busybox.nosuid /tmp/busybox
	cp /sbin/halt.sysvinit /tmp
	ln -s /tmp/halt.sysvinit /tmp/halt
	cp /sbin/reboot.sysvinit /tmp
	ln -s /tmp/reboot.sysvinit /tmp/reboot
	cp /bin/infobox /tmp
	cp /sbin/wget /tmp
	if [ -e /bin/cubefpctl ]; then cp /bin/cubefpctl /tmp; fi
	cp /mnt/network/resolv.conf /tmp
	cp /bin/grep /tmp

	cp /lib/ld* /tmp/lib		#for busybox
	cp /lib/libc.so.6 /tmp/lib				#for busybox
	cp /lib/libcrypt.so.1 /tmp/lib		#for busybox
	cp /usr/lib/libfreetype.so.6 /tmp/lib	#for infobox
	cp /lib/libz.so.1 /tmp/lib				#for infobox
	cp /lib/libm.so.6 /tmp/lib				#for infobox
	cp /lib/libgcc_s.so.1 /tmp/lib		#for infobox
	cp /usr/lib/libjpeg.so.62 /tmp/lib		#for infobox
	cp /usr/lib/libjpeg.so.8 /tmp/lib		#for infobox
	cp /usr/lib/libpng15.so.15 /tmp/lib		#for infobox
	cp /lib/libbz2* /tmp/lib		#for infobox
	cp /usr/lib/libcrypto* /tmp/lib		#for wget
	cp /lib/libssl* /tmp/lib		#for wget
	cp /usr/share/fonts/default.ttf /tmp	# for infobox

	cat /sbin/abfrage | sed "s#/usr/bin/awk#/tmp/awk#" > /tmp/abfrage
	chmod 777 /tmp/abfrage
	cat /sbin/emu.sh | sed "s#/bin/sh#/tmp/sh#" > /tmp/emu.sh
	chmod 777 /tmp/emu.sh
	cat /sbin/wget.info | sed "s#/bin/sh#/tmp/sh#" > /tmp/wget.info
	chmod 777 /tmp/wget.info
	cat /sbin/start_sec.sh | sed "s#/bin/sh#/tmp/sh#" > /tmp/start_sec.sh
	chmod 777 /tmp/start_sec.sh

	ln -s /tmp/busybox /tmp/killall
	ln -s /tmp/busybox /tmp/sleep
	ln -s /tmp/busybox /tmp/awk
	ln -s /tmp/busybox /tmp/dd
	ln -s /tmp/busybox /tmp/time
	ln -s /tmp/busybox /tmp/sync
	ln -s /tmp/busybox /tmp/mount
	ln -s /tmp/busybox /tmp/umount
	ln -s /tmp/busybox /tmp/mkdir
	ln -s /tmp/busybox /tmp/echo
	ln -s /tmp/busybox /tmp/sed
	ln -s /tmp/busybox /tmp/cut
	ln -s /tmp/busybox /tmp/tail
	ln -s /tmp/busybox /tmp/tr
	ln -s /tmp/busybox /tmp/date
	ln -s /tmp/busybox /tmp/basename
	ln -s /tmp/busybox /tmp/tar
	ln -s /tmp/busybox /tmp/cat
	ln -s /tmp/busybox /tmp/wc
	ln -s /tmp/busybox /tmp/rm
	ln -s /tmp/busybox /tmp/touch
	ln -s /tmp/busybox /tmp/ash
	ln -s /tmp/busybox /tmp/mv
	ln -s /tmp/ash /tmp/sh
	
	PATH="/tmp:$PATH"
	PATH="/tmp/mktmp:$PATH"
	export PATH
	LD_LIBRARY_PATH="/tmp/lib;/lib;/usr/lib"
	export LD_LIBRARY_PATH
	

}

### functions ###
flash_img()
{
	killall infobox
	infobox -pos -1 75% 9999 Update " flashing... please wait " &

	if [ -d /tmp/$boxtype ]; then
		rm -r /tmp/$boxtype
	fi
	unzip $file -x $boxtype/*.img -d /tmp
	rm $file
	bunzip2 -c -f /tmp/$boxtype/rootfs.tar.bz2 > /tmp/$boxtype/rootfs.tar 
	tar -x -f /tmp/$boxtype/rootfs.tar ./boot -C /tmp
	if [ $? != "0" ]; then
		killall infobox
		infobox -pos -1 70% 10010 "EROOR" "  Image not readable    " 
		exit 0
	fi
	echo "  flash kernel"
	flash-kernel /tmp/boot/zImage*$boxtype #### echo mu weg nach test
	sync
	/etc/init.d/autofs stop
	umount -l /mnt
	if [ ! -d /tmp/helproot ]; then
		mkdir /tmp/helproot
	else
		umount -l /tmp/helproot
	fi
	mount /dev/root /tmp/helproot
	
	make_tmp

	echo "  erase root"
	rm -rf /tmp/helproot/var/bin
	rm -rf /tmp/helproot/var/lib
	rm -rf /tmp/helproot/var/usr
	rm -rf /tmp/helproot/var/etc
	rm -rf /tmp/helproot/usr/bin
	rm -rf /tmp/helproot/usr/lib
	rm -rf /tmp/helproot/usr/sbin
	#rm -rf /tmp/helproot/lib
	rm -rf /tmp/helproot/etc
	rm -rf /tmp/helproot/sbin
	rm -rf /tmp/helproot/boot
	#rm -f /tmp/helproot/ba
	rm -f /tmp/helproot/.swfinfo
	#rm -f /tmp/helproot/.smb
	#rm -f /tmp/helproot/.cache
	rm -rf /tmp/helproot/bin
	echo "  write root"
	if [ "$boxtype" == "hd51" ]; then
		tar -x -f /tmp/$boxtype/rootfs.tar --exclude=./mnt --exclude=./var/media -C /tmp/helproot
	else
		tar -x -f /tmp/$boxtype/rootfs.tar -C /tmp/helproot 
	fi
	sync
	killall infobox
	infobox -pos -1 70% 10005 "Update" "        done        " "Restart in 5 seconds"
	reboot -f
}

killproc()
{
	count=0
	lastcount=`ps | tail -n1 | sed "s/ \+/ /g;s/^ //" | cut -d" " -f1`
	if [ "$boxtype" == "ufs910" ] || [ "$boxtype" == "ufs922" ]; then
		excludes="^ini inetd automount evremote2 telnetd update.sh infobox lircd"
	elif [ "$boxtype" == "atemio-nemesis" ] || [ "$boxtype" == "atemio5200" ] || [ "$boxtype" == "vusolo2" ] || [ $boxtype = "atemio6000" ] || [ $boxtype = "atemio6100" ] || [ $boxtype = "atemio6200" ]; then
		excludes="^ini inetd automount evremote2 telnetd update.sh infobox lircd $swtype"
	else
		excludes="^ini inetd automount evremote2 telnetd update.sh infobox lircd $swtype"
	fi
	while true; do
		count=$((count + 1))
		if [ -e "/proc/$count/cmdline" ]; then
			cmd=`cat "/proc/$count/cmdline"`
			if [ ! -z "$cmd" ]; then
				treffer=0
				for exclude in $excludes; do
					if echo "$cmd" | grep -q "$exclude"; then treffer=1; fi
				done
				if [ $treffer -eq 0 ]; then
					echo "[update.sh] killing pid=$count cmd=$cmd"
					kill -9 "$count"
				fi
			fi
		fi
		if [ $count -ge $lastcount ]; then break; fi
	done
}

kill_and_show()
{
	if [ -z "$killandshow" ]; then
		killall infobox
		infobox -pos -1 75% 9999 "Info" "            Killing processes            " "            Please wait            " &

		killandshow="1"
		emu.sh stop
		killall -9 rcS
		killproc
		echo "3" > /proc/sys/vm/drop_caches
# 	FIXME: kills update.sh why???
#		/sbin/fuser -k /dev/dvb/adapter0/frontend0
#		/sbin/fuser -k /dev/dvb/adapter0/frontend1
		echo "0" > /proc/progress
		if [ "$boxtype" == "ufs910" ] || [ "$boxtype" == "ufs922" ]; then
			echo "[workaround] killall -9 $swtype"
			killall -9 $swtype
			infobox 1 "nobox#/var/etc/boot/start.jpg"
		else
			skip1=1
		fi
		killall infobox
	fi
}

error()
{
	killall infobox
	infobox -pos -1 70% 10010 "Update failed" "$1" "" "Restart in 10 seconds" &
	echo "[update.sh] $1"
	for i in 9 8 7 6 5 4 3 2 1 0; do
		if [ "$boxtype" = "atemio520" ] || [ "$boxtype" = "atemio530" ]; then
			echo "R $i" > /dev/$vfd
		else
			echo "$2 ($i)" > /dev/$vfd
		fi
		sleep 1
	done
	if [ "$boxtype" = "atemio520" ] || [ "$boxtype" = "atemio530" ]; then
		echo "Ende" > /dev/$vfd
	else
		echo "Neustart" > /dev/$vfd
	fi
	echo "[update.sh] reboot"
#	init 6
	/tmp/reboot -f
	reboot -f
	exit
}

md5_check()
{
	if [ "$source" == "online" ];then
		md5=`/sbin/md5sum "$file" | cut -d"/" -f1 | tr -d " "`
		echo "[update.sh] md5=$md5"
		md5file=`cat "$file_md5" | tr -d " "`
		echo "[update.sh] md5file=$md5file"
		if [ "$md5" != "$md5file" ]; then
			error "MD5 check failed" "MD5 err"
		fi
	fi
}

got_online_img()
{
	if [ "$source" == "online" ];then
		killall infobox
		infobox -pos -1 75% 3 Update "  Loading image and md5  " &
#		if [ "$boxtype" = "atemio520" ] || [ "$boxtype" = "atemio530" ]; then
#			echo "Loading" > /tmp/$vfd
#		else
#			echo "Loading Image" > /tmp/$vfd
#		fi
		cd "$tmp"
		rm -f "$base"
		#rm -f "$base_md5"
		sleep 3
		killall infobox

		wget.info -T15 "$url/$urldir/$folder/$base"
		#wget.info -T15 "$url/$urldir/$folder/$base_md5"

		killall infobox
		infobox -pos -1 75% 20 Update "    Loading completed    " &
		#if [ "$boxtype" = "atemio520" ] || [ "$boxtype" = "atemio530" ]; then
		#	echo "Ok" > /tmp/$vfd
		#else
		#	echo "Loading ready" > /tmp/$vfd
		#fi
	fi
}

copy_to_tmp()
{
	if [ ! -e "$tmp/$base" ]; then
		killall infobox
		infobox -pos -1 75% 100 Update "  Copying image to $tmp  " &
#		if [ "$boxtype" = "atemio520" ] || [ "$boxtype" = "atemio530" ]; then
#			echo "Copy" > /tmp/$vfd
#		else
#			echo "Copying" > /tmp/$vfd
#		fi
		cp "$file" "$tmp/$base"
	fi
#	if [ ! -e "$tmp/$base_md5" ]; then
#		cp "$file_md5" "$tmp/$base_md5"
#	fi
	file="$tmp/$base"
#	file_md5="$tmp/$base_md5"
}

file_check()
{
	if [ ! -e "$file" ]; then
		error "Missing: File" "no file"
	fi
#	if [ ! -e "$file_md5" ] && [ "$source" == "online" ]; then
#		error "Missing: MD5 File" "no MD5"
#	fi
}

got_basename()
{
	if [ "$targetfull" != "fullbackup" ];then
		file=`echo "$origfile" | sed "s/_FULL_/_${part}_/"`
	fi
	file_md5="${file%.*}"; file_md5="${file_md5%.*}"; file_md5="$file_md5.md5"
#	file_md5=`echo $file | sed 's/.img/.md5/' | sed 's/.tar.gz/.md5/'`
	base=`basename "$file"`
	base_md5=`basename "$file_md5"`
}


### stop E2 (not TV) ###
#killall -stop $swtype

### change tmp if image is to big for /tmp ###
#if [ "$bigimage" == "1" ]; then
#	tmp=`dirname "$file"`
#fi

### show beginning of update ###
infobox -pos -1 75% 20 "Update" "  Start: Please wait  " &
#if [ "$boxtype" = "atemio520" ] || [ "$boxtype" = "atemio530" ]; then
#	echo "Start" > /dev/$vfd
#else
#	echo "Update started" > /dev/$vfd
#fi
sleep 3

### save orig filename ###
origfile="$file"
got_basename

### kill unneedet prozess and showiframe ###
##if [ "$boxtype" = "ufs910" ] || [ "$boxtype" = "ufs922" ]; then
##	kill_and_show
##fi

if [ "$update_to" == "flash" ]; then swap.sh swapalloff; fi

### remove tmp, exclude img and md5 ###
#targetlist="FULL $target"
#for part in $targetlist; do
#	got_basename
#	skipliste="$skipliste $file"
#done

#TEXT="| grep -v"
#for ROUND in $skipliste; do
#	SKIP="$SKIP $TEXT \"$ROUND\""
#done

#echo "find $tmp -xdev | "grep -v "^$tmp$" "$SKIP" > /tmp/tmp.cmd
#chmod 755 /tmp/tmp.cmd
#/tmp/tmp.cmd > /tmp/tmp.list

#tlist=`cat /tmp/tmp.list`
#rm -f /tmp/tmp.list
#for t in $tlist; do
#	mountpoint -q "$t"
#	if [ $? -ne 0 ]; then
#		echo "$t" >> /tmp/tmp.list
#	fi
#done

#rm -rf `cat /tmp/tmp.list`
#got_basename
## not working if image directly in /tmp
##rm -rf `find $tmp | grep -v "^$tmp$" | grep -v "$base" | grep -v "$base_md5"`


### copy all needet files to tmp ###
#make_tmp

killall infobox
got_online_img
if [ "$source" = "online" ]; then
	copy_to_tmp
fi
if [ "$update_to" == "flash" ]; then
	killall infobox
	### flash the image ###
	#if [ "$target" == "FULL" ] || [ "$target" == "ROOT" ]; then mount /tmp/lib /lib; fi
	flash_img
	if [ "$targetfull" != "fullbackup" ]; then
		rm -f "$file"
	fi
fi

### update to usb ###
if [ "$update_to" == "usb" ]; then
	echo "### update to usb ### not supported"

	#workaround for Obi Test
	flash_img
	if [ "$targetfull" != "fullbackup" ]; then
		rm -f "$file"
	fi
	#
	
fi

