#!/bin/sh -x
#

ARCH=$(cat /etc/.arch)

PYBIN=python3

if [ "$ARCH" == sh4 ];then
	PYBIN=python
fi

if [ "$1" == "remove" ];then
	opkg remove ${PYBIN}-flask --force-removal-of-dependent-packages
	exit
fi

if [ "$1" == "install" ];then
	opkg update
	opkg install ${PYBIN} ${PYBIN}-trio ${PYBIN}-xmlrpc ${PYBIN}-isodate ${PYBIN}-pycountry ${PYBIN}-pycryptodomex
	opkg install ${PYBIN}-requests ${PYBIN}-flask
fi

if [ "$1" == "start" ];then
	opkg update
	check1=`opkg list_installed ${PYBIN}-requests | wc -l`
	check2=`opkg list_installed ${PYBIN}-flask | wc -l`
	if [ "$check1" == 0 ] || [ "$check2" == 0 ];then
		opkg install ${PYBIN} ${PYBIN}-trio ${PYBIN}-xmlrpc ${PYBIN}-isodate ${PYBIN}-pycountry ${PYBIN}-pycryptodomex
		opkg install ${PYBIN}-requests ${PYBIN}-flask
	fi

	echo ntpdate start
	ntpdate -b ptbtime1.ptb.de
	echo vavoo start
	/mnt/swapextensions/etc/init.d/manage-vavoo.sh start
fi

if [ "$1" == "stop" ];then
	echo vavoo stop
	/mnt/swapextensions/etc/init.d/manage-vavoo.sh stop
fi

if [ "$1" == "restart" ];then
	echo vavoo restart
	/mnt/swapextensions/etc/init.d/manage-vavoo.sh restart
fi
