#!/bin/sh -x
#

ARCH=$(cat /etc/.arch)

PYBIN=python3

if [ "$ARCH" == sh4 ];then
	PYBIN=python
fi

if [ "$1" == "remove" ];then
	opkg remove ${PYBIN}-flask --force-removal-of-dependent-packages
	exit
fi

if [ "$1" == "install" ];then
	opkg update
	opkg install ${PYBIN} ${PYBIN}-trio ${PYBIN}-xmlrpc ${PYBIN}-isodate ${PYBIN}-pycountry ${PYBIN}-pycryptodomex
	opkg install ${PYBIN}-requests ${PYBIN}-flask
fi


if [ -e /mnt/swapextensions/usr/local/share/titan/plugins/network/vavoo/manage-vavoo.sh ];then
	INSTDIR=/mnt/swapextensions/usr/local/share/titan/plugins/network/vavoo
elif [ -e /mnt/swapextensions/usr/local/share/titan/plugins/network/vavoo/manage-vavoo.sh ];then
	INSTDIR=/var/swap/usr/local/share/titan/plugins/network/vavoo
elif [ -e /var/usr/local/share/titan/plugins/network/vavoo/manage-vavoo.sh ];then
	INSTDIR=/var/usr/local/share/titan/plugins/network/vavoo
fi

if [ -z "$INSTDIR" ];then
	echo [$0] skip manage-vavoo.sh is not installed
else
	if [ "$1" == "start" ];then
		opkg update
		check1=`opkg list_installed ${PYBIN}-requests | wc -l`
		check2=`opkg list_installed ${PYBIN}-flask | wc -l`
		if [ "$check1" == 0 ] || [ "$check2" == 0 ];then
			opkg install ${PYBIN} ${PYBIN}-trio ${PYBIN}-xmlrpc ${PYBIN}-isodate ${PYBIN}-pycountry ${PYBIN}-pycryptodomex
			opkg install ${PYBIN}-requests ${PYBIN}-flask
		fi

		echo [$0] ntpdate start
		ntpdate -b ptbtime1.ptb.de
		echo [$0] vavoo start
		$INSTDIR/manage-vavoo.sh start
	fi

	if [ "$1" == "stop" ];then
		echo [$0] vavoo stop
		$INSTDIR/manage-vavoo.sh stop
	fi

	if [ "$1" == "restart" ];then
		echo [$0] vavoo restart
		$INSTDIR/manage-vavoo.sh restart
	fi
fi
